<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat subscribers">
				<div class="info">
					<abbr><?php echo $tpl['total_subscribed'];?></abbr>
					<?php echo (int) $tpl['total_subscribed'] !== 1 ? strtolower(__('lblDashSubscribers', true)) : strtolower(__('lblDashSubscriber', true)); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat messages">
				<div class="info">
					<abbr><?php echo $tpl['total_messages'];?></abbr>
					<?php echo (int) $tpl['total_messages'] !== 1 ? strtolower(__('lblDashMessages', true)) : strtolower(__('lblDashMessage', true)); ?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat pending">
				<div class="info">
					<abbr><?php echo $tpl['total_pending'];?></abbr>
					<?php echo strtolower(__('lblDashPending', true)); ?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('lblDashLatestSubscribers');?></div>
			<div class="dashboard_column_top"><?php __('lblDashLatestSentMessages');?></div>
			<div class="dashboard_column_top"><?php __('lblDashSummary');?></div>
		</div>
		
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['latest_subscribers']);
				if ($cnt === 0)
				{
					?>
					<div class="dashboard_subscribe_row dashboard_row dashboard_row_last">
						<label><?php __('lblSubscriberNotFound'); ?></label>
					</div>
					<?php
				}else{
					foreach ($tpl['latest_subscribers'] as $k => $v)
					{
						$list_arr = array();
						foreach($v['lists'] as $group)
						{
							list($group_id, $group_title) = explode("~:~", $group);
							$list_arr[] = '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminGroups&amp;action=pjActionUpdate&amp;id='.$group_id.'">'.$group_title.'</a>';
						}
						?>
						<div class="dashboard_subscribe_row dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
							<label class="bold fs14"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminSubscribers&amp;action=pjActionUpdate&amp;id=<?php echo $v['id']?>"><?php echo $v['first_name'] . ' ' . $v['last_name']; ?></a></label>
							<label><?php echo $v['email']?></label>
							<label><?php __('lblDashSubscribed');?>: <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['created'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($v['created'])), 'H:i:s', $tpl['option_arr']['o_time_format']);?></label>
							<label><?php __('lblDashLists');?>: <?php echo join(", ", $list_arr);?></label>
						</div>
						<?php
					}
				} 
				?>
			</div>
			<div class="dashboard_column">
				<?php
				$cnt = count($tpl['latest_sent_messages']);
				if ($cnt === 0)
				{
					?>
					<div class="dashboard_message_row dashboard_row dashboard_row_last">
						<label><?php __('lblMessageNotFound'); ?></label>
					</div>
					<?php
				}else{
					?>
					<div class="dashboard_message_row dashboard_row">
						<label><input type="button" value="<?php __('btnSendMessage'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminMessages&action=pjActionSend';" /></label>
					</div>
					<?php
					foreach ($tpl['latest_sent_messages'] as $k => $v)
					{
						?>
						<div class="dashboard_message_row dashboard_row<?php echo $k + 1 !== $cnt ? NULL : ' dashboard_row_last'; ?>">
							<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminMessages&amp;action=pjActionUpdate&amp;id=<?php echo $v['id']?>"><?php echo $v['subject']; ?></a></label>
							<label><?php __('lblDashDate');?>: <?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['sent_on']));?></label>
							<label><?php __('lblDashSentTo');?>: <?php echo $v['subscribers'];?> <?php echo $v['subscribers'] != 1 ? mb_strtolower(__('lblDashSubscribers', true)) : mb_strtolower(__('lblDashSubscriber', true));?></label>
						</div>
						<?php
					}
				} 
				?>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_besent_row dashboard_row dashboard_row_last">
					<?php
					if($tpl['total_lists'] > 1)
					{ 
						?>
						<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminGroups&amp;action=pjActionIndex"><?php echo $tpl['total_lists'];?> <?php echo $tpl['total_lists']!=1 ? __('lblDashPluralLists'): __('lblDashSingularList');?></a></label>
						<?php
					}else{
						?>
						<label><?php echo $tpl['total_lists'];?> <?php echo $tpl['total_lists']!=1 ? __('lblDashPluralLists'): __('lblDashSingularList');?></label>
						<?php
					} 
					?>
					<label><?php __('lblDashTotalSubscribers');?>: <span class="fs16 bold"><?php echo $tpl['total_subscribers'];?></span></label>
					<label><?php __('lblDashSubscribed');?>: <?php echo $tpl['total_subscribers'] - $tpl['total_unsubscribers'];?></label>
					<label><?php __('lblDashUnsubscribed');?>: <?php echo $tpl['total_unsubscribers'];?></label>
					<label><?php __('lblDashNewToday');?>: <span class="fs16 bold"><?php echo $tpl['total_new_today'];?></span></label>
					<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminSubscribers&action=pjActionImport"><?php __('lblDashImportSubscribers');?></a></label>
					
					<br/><br/>
					<label class="bold fs13"><?php __('menuMessages');?></label>
					<label><?php echo $tpl['total_active_messages'];?> <?php echo $tpl['total_active_messages']!=1 ? __('lblDashActiveMessages'): __('lblDashActiveMessage');?></label>
					<label><?php __('lblTotalSent');?>: <?php echo $tpl['total_sent'];?></label>
					<label><?php __('lblDashWaitingToBeSent');?>: <?php echo $tpl['total_pending'];?></label>
					<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminMessages&action=pjActionSend"><?php __('lblDashSendMessage');?></a></label>
					<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminQueues&action=pjActionIndex"><?php __('lblDashViewMailQueue');?></a></label>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo date("F d, Y H:i", strtotime($_SESSION[$controller->defaultUser]['last_login'])); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo $other; ?>
			</div>
			<div class="dashboard_hour"><?php echo $hour; ?></div>
		</div>
	</div>
	<?php
}
?>