<?php
mt_srand();
$index = mt_rand(1, 9999);
$front_required = __('front_required', true);
$front_validation = __('front_validation', true); 

foreach ($front_required as $k => $v) {
	$front_required[$k] = htmlspecialchars($v, ENT_QUOTES);
}
foreach ($front_validation as $k => $v) {
	$front_validation[$k] = htmlspecialchars($v, ENT_QUOTES);
}
$validate = str_replace(array('"', "'"), array('\"', "\'"), __('front_validation', true, true));
$theme = isset($_GET['theme']) ? $_GET['theme'] : $tpl['option_arr']['o_theme'];
if((int) $theme > 0)
{
	$theme = 'theme' . $theme;
}
?>
<div id="pjWrapperNewsletter_<?php echo $theme;?>">
	<div id="pjNewsletterContainer_<?php echo $index;?>" class="container-fluid pjCfContainer nsl-form-container">
		<br>
		<div class="panel panel-default pjCfForm">
			<div class="panel-heading pjCfFormHead">
				<strong class="pjCfFormTitle"><?php __('front_label_form');?></strong>
			</div><!-- /.panel-heading pjCfFormHead -->
			<div class="panel-body pjCfFormBody">
				<form action="" method="post" id="nsl_subscribe_form_<?php echo $index;?>" name="nsl-subscribe-form_<?php echo $index;?>" class="form-horizontal nsl-form" novalidate="true" data-toggle="validator" role="form" >
					<?php
					if(isset($_GET['group_id']))
					{	 
						?>
						<input type="hidden" name="group_id" value="<?php echo $_GET['group_id'];?>"/>
						<?php
					}else{
						?>
						<div class="form-group">
							<label class="col-sm-3 control-label"><?php __('front_label_select_list');?></label>
							
							<div class="col-sm-9">
								<select name="group_id" class="form-control nsl-select required pjNlGroupSelector" lang="<?php echo ($front_required['list']); ?>">
									<option value="">-- <?php __('front_label_choose'); ?>--</option>
									<?php
									foreach ($tpl['group_arr'] as $k => $v)
									{
									    ?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['group_title']); ?></option><?php
									}
									?>
								</select>
							</div>
						</div>
						<?php
					}
					?>
					<div id="nsl_form_field_<?php echo $index;?>"></div>
				</form>
			</div>
		</div>
	</div>	
</div>

<script type="text/javascript">
var pjQ = pjQ || {},
	pjNewsletter_<?php echo $index; ?>;
(function () {
	"use strict";
	
	var isSafari = /Safari/.test(navigator.userAgent) && /Apple Computer/.test(navigator.vendor),
		
	loadCssHack = function(url, callback){
		var link = document.createElement('link');
		link.type = 'text/css';
		link.rel = 'stylesheet';
		link.href = url;

		document.getElementsByTagName('head')[0].appendChild(link);

		var img = document.createElement('img');
		img.onerror = function(){
			if (callback && typeof callback === "function") {
				callback();
			}
		};
		img.src = url;
	},
	loadRemote = function(url, type, callback) {
		if (type === "css" && isSafari) {
			loadCssHack(url, callback);
			return;
		}
		var _element, _type, _attr, scr, s, element;
		
		switch (type) {
		case 'css':
			_element = "link";
			_type = "text/css";
			_attr = "href";
			break;
		case 'js':
			_element = "script";
			_type = "text/javascript";
			_attr = "src";
			break;
		}
		
		scr = document.getElementsByTagName(_element);
		s = scr[scr.length - 1];
		element = document.createElement(_element);
		element.type = _type;
		if (type == "css") {
			element.rel = "stylesheet";
		}
		if (element.readyState) {
			element.onreadystatechange = function () {
				if (element.readyState == "loaded" || element.readyState == "complete") {
					element.onreadystatechange = null;
					if (callback && typeof callback === "function") {
						callback();
					}
				}
			};
		} else {
			element.onload = function () {
				if (callback && typeof callback === "function") {
					callback();
				}
			};
		}
		element[_attr] = url;
		s.parentNode.insertBefore(element, s.nextSibling);
	},
	loadScript = function (url, callback) {
		loadRemote(url, "js", callback);
	},
	loadCss = function (url, callback) {
		loadRemote(url, "css", callback);
	},
	getSessionId = function () {
		return sessionStorage.getItem("session_id") == null ? "" : sessionStorage.getItem("session_id");
	},
	createSessionId = function () {
		if(getSessionId()=="") {
			sessionStorage.setItem("session_id", "<?php echo session_id(); ?>");
		}
	},
	options = {
		server: "<?php echo PJ_INSTALL_URL; ?>",
		folder: "<?php echo PJ_INSTALL_URL; ?>",
		theme: "<?php echo $theme;?>",
		index: <?php echo $index; ?>,
		locale: <?php echo isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : $controller->pjActionGetLocale(); ?>,
		group_id: "<?php echo isset($_GET['group_id']) ? $_GET['group_id'] : null;?>",
		validate: <?php echo pjAppController::jsonEncode($validate); ?>,		
		validation: {
			error_email_invalid: "<?php echo $front_validation['email_invalid']; ?>",
			error_email_used: "<?php echo $front_validation['email_used']; ?>",
			error_birthday_invalid: "<?php echo $front_validation['birthday_invalid']; ?>",
			error_captcha_incorrect: "<?php echo $front_validation['captcha_incorrect']; ?>"
		},
		message: {
			info: "<?php echo pjSanitize::clean(__('front_label_subscribe_info', true)); ?>",
			success: "<?php echo pjSanitize::clean(__('front_label_subscribe_success', true)); ?>",
			error: "<?php echo pjSanitize::clean(__('front_label_subscribe_error', true)); ?>"
		}
	};
	<?php
	$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
	$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
	?>
	loadScript("<?php echo PJ_INSTALL_URL . $dm->getPath('storage_polyfill'); ?>storagePolyfill.min.js", function () {
		if (isSafari) {
			createSessionId();
			options.session_id = getSessionId();
		}else{
			options.session_id = "";
		}
		
		loadScript("<?php echo PJ_INSTALL_URL . $dm->getPath('pj_jquery'); ?>pjQuery.min.js", function () {
			loadScript("<?php echo PJ_INSTALL_URL . $dm->getPath('pj_validate'); ?>pjQuery.validate.min.js", function () {
				loadScript("<?php echo PJ_INSTALL_URL . $dm->getPath('pj_bootstrap'); ?>pjQuery.bootstrap.min.js", function () {
					loadScript("<?php echo PJ_INSTALL_URL . PJ_JS_PATH ?>pjLoad.js", function () {
						pjNewsletter = pjNewsletter(options);
					});
				});
			});
		});
	});
})();
</script>